/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.structures.thema;

public class ThemaItem {
    private Integer conceptID;
    private String conceptName;
    private String conceptDesc;
    private Integer thesaurusID;
    private String titleLemmas;
    private String descLemmas;

    public void setConceptID(Integer i){
        conceptID=i;
    }
    public void setConceptName(String s){
        conceptName=s;
    }
    public void setConceptDesc(String s){
        conceptDesc=s;
    }
    public void setThesaurusID(Integer i){
        thesaurusID=i;
    }
    public void setTitleLemmas(String s){
        titleLemmas=s;
    }
    public void setDescLemmas(String s){
        descLemmas=s;
    }

    public int getConceptID(){
        return conceptID;
    }
    public String getConceptName(){
        return conceptName;
    }
    public String getConceptDesc(){
        return conceptDesc;
    }
    public int getThesaurusID(){
        return thesaurusID;
    }
    public String getTitleLemmas(){
        return titleLemmas;
    }
    public String getDescLemmas(){
        return descLemmas;
    }

    @Override
    public String toString(){
        return conceptName;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final ThemaItem other = (ThemaItem) obj;
        if ((this.conceptID == null) ? (other.conceptID != null) : !this.conceptID.equals(other.conceptID)) {
            return false;
        }
        return true;
    }
}
